﻿<?php
session_start();
include 'conexao.php'; // Inclua a conexão com o banco de dados

// Verifica se o usuário está logado e tem o perfil correto
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SUBDIRECÇÃO PEDAGÓGICA') {
    header("Location: login.php");
    exit;
}

// Carrega os dados do usuário logado
$usuario = $_SESSION['usuario'];
$nome = $usuario['nome'] ?? 'Subdiretor(a)';
$foto = $usuario['foto'] ?? 'sem-foto.png';
$mensagem_upload = $_SESSION['mensagem_upload'] ?? ''; // Pega a mensagem de upload da sessão

// Limpa a mensagem da sessão para que ela não seja exibida novamente após a atualização da página
unset($_SESSION['mensagem_upload']);

// LÓGICA PARA PROCESSAR O UPLOAD DA FOTO DE PERFIL
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['upload_foto'])) {
    if (isset($_FILES['nova_foto']) && $_FILES['nova_foto']['error'] === UPLOAD_ERR_OK) {
        $diretorio_destino = 'fotos/';
        // Verifica se o diretório de destino existe e é gravável
        if (!is_dir($diretorio_destino)) {
            mkdir($diretorio_destino, 0777, true); // Cria o diretório se não existir
        }
        if (!is_writable($diretorio_destino)) {
            $_SESSION['mensagem_upload'] = "❌ Erro do servidor: o diretório de fotos não existe ou não tem permissão de escrita.";
            header("Location: painel_subdireccao_pedagogica.php");
            exit;
        }

        $extensao = pathinfo($_FILES['nova_foto']['name'], PATHINFO_EXTENSION);
        // Gera um nome único para o arquivo para evitar colisões
        $foto_nova_nome = uniqid('perfil_') . '.' . $extensao;
        $caminho_completo = $diretorio_destino . $foto_nova_nome;

        if (move_uploaded_file($_FILES['nova_foto']['tmp_name'], $caminho_completo)) {
            // Atualiza o nome da foto no banco de dados
            $usuario_id = $_SESSION['usuario']['id']; // Assumindo que o ID do usuário está na sessão
            $stmt = $conn->prepare("UPDATE usuarios SET foto = ? WHERE id = ?");
            $stmt->bind_param("si", $foto_nova_nome, $usuario_id);
            if ($stmt->execute()) {
                // Atualiza a variável de sessão para que a foto seja exibida imediatamente
                $_SESSION['usuario']['foto'] = $foto_nova_nome;
                $foto = $foto_nova_nome; // Atualiza a variável local
                $_SESSION['mensagem_upload'] = "✅ Foto de perfil atualizada com sucesso!";
            } else {
                $_SESSION['mensagem_upload'] = "❌ Erro ao atualizar o banco de dados.";
                // Remova a foto do servidor se o banco de dados falhar
                unlink($caminho_completo);
            }
            $stmt->close();
        } else {
            $_SESSION['mensagem_upload'] = "❌ Erro ao fazer o upload da foto.";
        }
    } else {
        $_SESSION['mensagem_upload'] = "⚠️ Por favor, selecione um arquivo de foto.";
    }
    // Redireciona de volta para o painel para exibir a mensagem e evitar reenvio do formulário
    header("Location: painel_subdireccao_pedagogica.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Painel Subdirecção Pedagógica</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="js/chart.umd.js"></script>
    <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="adminlte/dist/css/adminlte.min.css">
    <style>
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background-color: #f4f6f9; }
        .sidebar { width: 260px; background: #001f3f; color: white; position: fixed; top: 0; bottom: 0; padding-top: 60px; z-index: 999; }
        .sidebar a { display: block; color: white; padding: 15px 20px; text-decoration: none; }
        .sidebar a:hover { background: #0056b3; }
        .topbar { position: fixed; left: 260px; right: 0; top: 0; height: 60px; background: #003366; color: white; display: flex; align-items: center; justify-content: space-between; padding: 0 20px; z-index: 1000; }
        .topbar .user-info { display: flex; align-items: center; gap: 10px; }
        .topbar img { width: 40px; height: 40px; border-radius: 50%; object-fit: cover; border: 2px solid white; cursor: pointer; }
        .main-content { margin-left: 260px; margin-top: 60px; padding: 30px; }

        .charts-container {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-top: 30px;
        }

        .chart-box {
            flex: 1 1 45%;
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .chart-box h4 {
            margin-bottom: 10px;
            color: #003366;
            font-weight: bold;
            text-align: center;
        }

        canvas {
            width: 100% !important;
            height: 300px !important;
        }

        /* Estilo da mensagem de sucesso/erro */
        .mensagem {
            margin-top: 10px;
            font-weight: bold;
            padding: 10px;
            border-radius: 5px;
            text-align: center;
        }
        .mensagem.sucesso {
            color: #28a745;
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
        }
        .mensagem.erro {
            color: #dc3545;
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
        }
    </style>
</head>
<body>

<div class="sidebar">

     <a href="estatistica_geral.php"><i class="fas fa-chart-bar"></i> Estatística Global</a>
      <a href="pedagogico_lista.php"><i class="fas fa-chart-bar"></i> Estatística Com Gráfico</a>

    <a href="estatistica_turma.php"><i class="fas fa-chart-bar"></i> Estatística</a>
    <a href="#"><i class="fas fa-chalkboard-teacher"></i> Desempenho do Professor</a>
   

 <a href="historico_lancamentos.php"><i class="fas fa-calendar-alt"></i> Histórico de Lançamentos</a>

    <a href="consultar_horario.php"><i class="fas fa-calendar-alt"></i> Gerador de horários</a>
    <a href="documentos_recebidos.php">📂 Documentos Recebidos</a>
    <a href="enviar_documento.php"><i class="fas fa-upload"></i> Enviar Documento</a>
    <a href="atribuir_disciplina.php"><i class="fas fa-book"></i> Atribuir Disciplina</a>
    <a href="cadastrar_disciplina_anterior1.php"><i class="fas fa-plus-circle"></i> Cadastrar Disciplina</a>
    <a href="cadastrar_usuario1.php"><i class="fas fa-user-plus"></i> Cadastrar Usuário</a>
    <a href="definir_tempos_disciplina.php"><i class="fas fa-clock"></i> Definir tempos semanais</a>
    <a href="configuracoes.php"><i class="fas fa-cogs"></i> Configurações</a>
 <a href="listar_planificacoes.php"><i class="fas fa-cogs"></i>Dosificaçõs</a>
 <a href="verificar_planos.php"><i class="fas fa-cogs"></i>Ver planificações</a>
 <a href="listar_professores.php"><i class="fas fa-cogs"></i>Acessar Professores</a>
 <a href="mapa_aproveitamento.php"><i class="fas fa-cogs"></i>Mapa de Aproveitamento</a>
<a href="subdirector_control_presenca.php"><i class="fas fa-cogs"></i>Gestão de Seminários e Reuniões</a>
    <a href="lista_funcionarios.php"><i class="fas fa-cogs"></i>Avaliar Funcionários</a>
    <a href="editar_aluno.php"><i class="fas fa-cogs"></i>editar aluno</a>
    <a href="cadastrar_turma2.php"><i class="fas fa-calendar-check"></i> Cadastrar Turma</a>
<a href="matricular_aluno.php"><i class="fas fa-calendar-check"></i> matrículas</a>

    <a href="ativar_prazos.php"><i class="fas fa-calendar-check"></i> Definir Prazos de Lançamento</a>
   

 <a href="fechar_trimestre_geral.php"><i class="fas fa-calendar-check"></i> fechar trimestre</a>
     <a href="ver_turmas.php"><i class="fas fa-calendar-times"></i> Ver Turmas</a>
         <a href="preencher_termos_anteriores.php"><i class="fas fa-calendar-times"></i> Termos</a>
 
  <a href=" fechar_trimestre_geral.php"><i class="fas fa-calendar-times"></i> Fechar Lançamento</a>

<a href="lista_alunos_turma.php"><i class="fas fa-calendar-times"></i> Ver listas</a>
    <a href="alterar_senha.php"><i class="fas fa-calendar-times"></i> Alterar Senha</a>
    <a href="cadastrar_nota.php"><i class="fas fa-edit"></i> Lançar Nota</a>
    <a href="painel_certificados.php"><i class="fas fa-certificate"></i> Certificado</a>
    <a href="pauta_final.php"><i class="fas fa-clipboard-list"></i> Pauta Final</a>
    <a href="login.php"><i class="fas fa-sign-out-alt"></i> Sair</a>
</div>

<div class="topbar">
    <div class="topbar-left">
        <strong>PAINEL DA SUBDIRECÇÃO PEDAGÓGICA</strong> | <span>Bem-vindo: <strong><?= htmlspecialchars($nome) ?></strong></span>
    </div>
    <div class="user-info">
        <form action="" method="post" enctype="multipart/form-data" id="fotoUploadForm">
            <label for="nova_foto">
                <img src="fotos/<?= htmlspecialchars($foto) ?>" alt="Foto" id="userPhoto">
            </label>
            <input type="file" name="nova_foto" id="nova_foto" style="display:none;" onchange="this.form.submit();">
            <input type="hidden" name="upload_foto" value="1"> </form>
        <span><?= htmlspecialchars($nome) ?></span>
    </div>
</div>

<div class="main-content">
    <h2>Bem-vindo(a), <?= htmlspecialchars($nome) ?>!</h2>
    <p>Selecione uma funcionalidade na barra lateral.</p>

    <?php if (!empty($mensagem_upload)): ?>
        <div class="mensagem <?= strpos($mensagem_upload, '✅') !== false ? 'sucesso' : 'erro' ?>">
            <?= $mensagem_upload ?>
        </div>
    <?php endif; ?>

    <div style="margin-top: 30px; display: flex; gap: 20px;">
        <a href="gerar_horario.php">
            <button style="padding: 12px 20px; font-size: 16px; background-color: #003366; color: white; border: none; border-radius: 5px; cursor: pointer;">
                <i class="fas fa-clock"></i> Gerar Horário
            </button>
        </a>
        <a href="definir_tempos_disciplina.php">
            <button style="padding: 12px 20px; font-size: 16px; background-color: #0069d9; color: white; border: none; border-radius: 5px; cursor: pointer;">
                <i class="fas fa-list-ol"></i> Definir Tempos Semanais
            </button>
        </a>
    </div>

    <div class="charts-container" style="margin-top: 40px;">
        <div class="chart-box">
            <h4>Evolução de Notas dos Professores</h4>
            <canvas id="graficoPizzaProfessores"></canvas>
        </div>

        <div class="chart-box">
            <h4>Evolução de Notas dos Alunos</h4>
            <canvas id="graficoColunaAlunos"></canvas>
        </div>
    </div>
</div>

<script>
    // Gráfico de Pizza (Professores)
    new Chart(document.getElementById('graficoPizzaProfessores'), {
        type: 'pie',
        data: {
            labels: ['Excelente', 'Bom', 'Satisfatório', 'Insuficiente'],
            datasets: [{
                label: 'Desempenho',
                data: [30, 40, 20, 10],
                backgroundColor: ['#28a745', '#007bff', '#ffc107', '#dc3545']
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { position: 'bottom' }
            }
        }
    });

    // Gráfico de Colunas (Alunos)
    new Chart(document.getElementById('graficoColunaAlunos'), {
        type: 'bar',
        data: {
            labels: ['1º Tri', '2º Tri', '3º Tri'],
            datasets: [{
                label: 'Notas Média',
                data: [10.5, 12.0, 13.2],
                backgroundColor: '#003366'
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    max: 20
                }
            },
            plugins: {
                legend: { display: false }
            }
        }
    });
</script>
</body>
</html>